# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 1999,2002 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package SR_cli_utils;
#"@(#)96   1.39   src/rsct/registry/cli/pm/SR_cli_utils.pm.perl, srcli, rsct_rpyxh, rpyxht1f3 2/21/01 12:06:28"
######################################################################
#                                                                    #
# Package: SR_cli_utils.pm                                           #
#                                                                    #
# Description:                                                       #
#   This package contains utility/common subroutines for the PERL    #
#   System Registry CLI commands.                                    #
#                                                                    #
# Subroutines Available:                                             #
#   save_result_table - given a local  input table handle and a      #
#     location in the current System Registry, uses the CT::SR::move_#
#     table command to save the local table. Called primarily by     #
#     joinsr and selectsr to save the results of those commands.     #
#                                                                    #
#   init_session - initializes any given system registry session,    #
#     including opening the working tree, changing the current       #
#     directory when relative directories are used, and mounting     #
#     the directory.  Requires mount point and chage directory flag  #
#     as input paramaters.                                           #
#                                                                    #
#   term_session - the opposite of init_session.  It terminates any  #
#     given system registry session, unmounting the working          #
#     directory and closing the tree.                                #
#                                                                    #
#   isRelative - determines if the input name (table name or a       #
#     directory name) contains a relative or absolute path.          #
#                                                                    #
#   get_table_metadata - get metadata via an extension call for a    #
#     given table handle.                                            #
#                                                                    #
#   free_table_metadata - free memory associated with table metadata.#
#                                                                    #
#   make_value_struct_t - build a structure containing 2 array       #
#     references to be used in passing data to SR extensions.        #
#                                                                    #
#   get_fields_by_index - get data from a System Registry table,     #
#     using an index reference.                                      #
#                                                                    #
#   open_table - open a System Registry table.                       #
#                                                                    #
#   error_exit - verify return code as valid, and close the session  #
#       as required by entries in the %main::Cleanup hash.           #
#       Does not return to the calling program. Exits within sub.    #
#                                                                    #
#   set_session_variables - fully qualify absolute table/directory   #
#       references, and determine if the current working directory   #
#       needs to be set (it is if the entry is relative.)            #
#                                                                    #
#   printCIMsg - print common srcli informational messages.          #
#                                                                    #
#   printCEMsg - print common srcli error messages.                  #
#                                                                    #
# Subroutines included in package but not exported:                  #
#   check_mount_env_var - checks a string and parses it assuming     #
#     it has the same structure as CT_SR_MOUNT. Passes out info      #
#     regarding the type and location of mount_tree call to make     #
#     based on the contents of the input string.                     #
#                                                                    #
# Examples:                                                          #
#   $rc = save_result_table($table_handle, $table_name, $mount_point,#
#       $program_name, $overwrite);                                  #
#                                                                    #
#   ($rc $tree_handle) = init_session("/SR", isRelative("/Node"),    #
#                              "lssr");                              #
#                                                                    #
#   $rc = term_session($tree_handle, "/SR", "lssr");                 #
#                                                                    #
#   $rc = get_table_metadata($table_handle);                         #
#                                                                    #
#   $rc = free_table_metadata($metadata);                            #
#                                                                    #
#   ($rc, $value_struct_t) = make_value_struct_t($column_definitions,#
#       $columns_to_set, $print_system_cols, $input_data,            #
#       $program_name);                                              #
#                                                                    #
#   ($rc, $results) = get_fields_by_index($table_handle, $row_index, #
#       $column_names, $value_struct_t, $program_name);              #
#                                                                    #
#   ($rc, $table_handle) = open_table($tree_handle,                  #
#       $system_table_name, $table_name, $permissions, $program_name)#
#                                                                    #
#   ($Set_work_dir, $name) = set_session_variables($input_name)      #
#                                                                    #
#   Best usage of error_exit:                                        #
#   ($rc == 0) || error_exit($rc);                                   #
#                                                                    #
#   printCEMsg("EMsgSRcliSRCommandFailure", "srmkdir",               #
#                               "sr_open_tree", $rc);                #
#                                                                    #
#--------------------------------------------------------------------#
# Inputs:                                                            #
#   /usr/sbin/rsct/msgmaps/srcli.srcli.map - message mapping         #
#                                                                    #
# Outputs:                                                           #
#   stdout - common informational messages that get displayed.       #
#   stderr - common error messages that get displayed.               #
#                                                                    #
# External References:                                               #
#   Commands: $LSMSG                                                 #
#   Extensions:  SR.pm                                               #
#   Environment Variables: CT_SR_HOME, CT_SR_NUM_RETRIES,            #
#                               CT_SR_TIMEOUT                        #
#                                                                    #
# Tab Settings:                                                      #
#   4 and tabs should be expanded to spaces before saving this file. #
#   in vi:  (:set ts=4  and   :%!expand -4)                          #
#                                                                    #
# Change Activity:                                                   #
#   000900 HGJ: Initial delivery.                                    #
#                                                                    #
######################################################################

use Exporter ();
@ISA = qw(Exporter);
@EXPORT_OK = qw(init_session 
                term_session 
                isRelative
                printCIMsg 
                printCEMsg 
                save_result_table
                $DEFAULT_GLOBAL_MOUNT_POINT
                make_value_struct_t
                get_table_metadata
                free_table_metadata
                get_fields_by_index
                open_table
                set_session_variables
                clean_session
                error_exit
);

use Env qw(CT_SR_HOME CT_SR_NUM_RETRIES CT_SR_TIMEOUT);
use locale;

use lib "/usr/sbin/rsct/pm";

use CT::CT;
use CT::CT qw(:ct_data_type_t);
use CT_cli_input_utils qw (convert_input_value);

use CT::SR qw(:sr_qualifier_t);
use CT::SR;
use CT::SRrc;
use SR_cli_rc qw(:return_codes);


#--------------------------------------------------------------------#
# Global Variables                                                   #
#--------------------------------------------------------------------#
$MSGCAT = "srcli.cat";                 # msg catalogue for this cmd
$MSGSET = "srcli";                     # common message set

$CTDIR = "/usr/sbin/rsct";             # RSCT root directory
$CTBINDIR = "$CTDIR/bin";              # Cluster Bin directory path
$LSMSG = "$CTBINDIR/ctdspmsg";         # list / display message rtn
$ENV{'MSGMAPPATH'} = "$CTDIR/msgmaps"; # msg maps used by $LSMSG

# Constants
$TRUE               = 1;
$FALSE              = 0;

# Used for local or global mount tree calls
$DEFAULT_LOCAL_MOUNT_POINT = "/var/ct/IW/registry/local_tree";
$DEFAULT_GLOBAL_MOUNT_POINT = "/SR";


#--------------------------------------------------------------------#
# Begin Exported Subroutines (with @EXPORT_OK, -> on demand).        #
#--------------------------------------------------------------------#

#--------------------------------------------------------------------#
# sub set_session_variables:                                         #
#  Takes an incoming table name and checks it to see if it needs to  #
#  be converted from a relative name or not, passes out the edited   #
#  table name (if it's absolute, it's left alone.) Also passes out   #
#  a boolean indicating that the current working directory should    #
#  be set for the session to be initiated.                           #
#  This subroutine should be called before open_session is called.   #
#                                                                    #
# Parameters:                                                        #
#   $table_name  - name to be checked if is relative or absolute     #
#   $mount_point - mount point for System Registry - added on to the #
#                  table_name if applicable.                         #
#                                                                    #
# Returns:                                                           #
#   $set_work_dir - flag to say whether current working directory    #
#                   should be set or not.                            #
#   $table - adjusted table name, for use in init_session.           #
#                                                                    #
# Globals used:                                                      #
#   $DEFAULT_GLOBAL_MOUNT_POINT - mount point for System Registry.   #
#--------------------------------------------------------------------#
sub set_session_variables 
{
my ($table_name) = @_;
my ($name, $table, $set_work_dir);

# Check to see if the table name passed in is relative. If so,
# then use it as is for starting up the session. Otherwise,
# add on the default global mount point.
# The $set)work_dir flag is to say whether the current working
# Directory should be set, as with relative table name usage.

if (isRelative($table_name)) {
    $set_work_dir= $TRUE;
    $table = $table_name;
}
else {
    $set_work_dir = $FALSE;
    $table = $DEFAULT_GLOBAL_MOUNT_POINT.$table_name;
}

return ($set_work_dir, $table);
}   # end set_session_variables


#--------------------------------------------------------------------#
# sub save_result_table:                                             #
#  Uses CT::SR:move_table to save the result of the select to a table#
#  in the System Registry. Called in response to the $opt_r flag.    #
#                                                                    #
# Parameters:                                                        #
#   $table       - table handle to be saved                          #
#   $table_name   - name the local table is to be saved to           #
#   $overwrite   - flag denoting whether existing table should be    #
#                overwritten with the moved table                    #
#                                                                    #
# Returns:                                                           #
#   $local_rc    - local return code                                 #
#--------------------------------------------------------------------#
sub save_result_table 
{
my ($table, $table_name, $overwrite) = @_;

my $local_rc = 0;
my $new_table = "";

$main::Trace && print STDERR "Entered save_result_table($table_name)\n";

# TODO: could this ever be considered a move across mount points?

$main::Trace && print STDERR "Calling CT::SR::move_table\n";
$local_rc = CT::SR::move_table($table, $table_name, $overwrite);
$main::Trace && 
    print STDERR "CT::SR::move_table return code: $local_rc\n";

if ($local_rc != 0) {
    if ($local_rc == SR_TABLE_EXISTS) {
        printCEMsg("EMsgSRcliTableExists", $table_name);
        $local_rc = SR_CLI_USER_ERROR;
    }
    elsif ($local_rc == SR_NO_PERMISSION_TARGET) {
        printCEMsg("EMsgSRcliNoPermissionTarget", $table_name);
        $local_rc = SR_CLI_USER_ERROR;
    }
    elsif ($local_rc == SR_NO_PERMISSION_SOURCE) {
        printCEMsg("EMsgSRcliNoPermissionSource", $table_name);
        $local_rc = SR_CLI_USER_ERROR;
    }
    elsif ($local_rc == SR_NO_DIRECTORY) {
        printCEMsg("EMsgSRcliNoDirectory");
    }
    elsif ($local_rc == SR_ILLEGAL_OPERATION) {
        printCEMsg("EMsgSRcliIllegalOperation", $table_name);
        $local_rc = SR_CLI_USER_ERROR;
    }
    else {
        printCEMsg("EMsgSRcliErrorMovingTable", $table_name);
        printCEMsg("EMsgSRcliSRCommandFailure", "sr_move_table", 
                            $local_rc);
        $local_rc = SR_CLI_REGISTRY_ERROR;
    }
}

$main::Trace && print STDERR "Leaving save_result_table($local_rc)\n";

return $local_rc;
}   # end save_result_table


#--------------------------------------------------------------------#
# sub check_mount_env_var:                                           #
#  Checks the contents of the incoming variable (assumed to be of the#
#  same structure as CT_SR_MOUNT) to determine which type of         #
#  mount will be completed, and the mount point to be used.          #
#                                                                    #
# Parameters:                                                        #
#   $mount_var   in  String to be checked as if it was same format as#
#                    CT_SR_MOUNT.                                    #
#                                                                    #
# Returns:                                                           #
#   $mount_var   - mount point or file system path to be used in     #
#                  mountin a global or local tree.                   #
#   $which_mount - either 'global' or 'local', depending on the type #
#                  of mount command the incoming mount_var indicates.#
#   $server_list - list of servers to be contacted during the a      #
#                  global mount.                                     #
#                                                                    #
# Global Variables:                                                  #
#  $main::Trace    in  turns trace mode on. trace mode on.           #
#--------------------------------------------------------------------#
sub check_mount_env_var 
{
my $mount_var = shift;

# CT_SR_MOUNT local:<dir>
# CT_SR_MOUNT local
# CT_SR_MOUNT global:<host:IP>
# This will be setting the server to mount to
# CT_SR_MOUNT global
# both of these will need default values

my $server_list = NULL;
my $which_mount = "";

if ($mount_var =~ /^local/) {
    # Parse off the directory, if there is none, then
    # use the default

    $mount_var=~ s/^local//; # strip off the header
    $mount_var=~ s/^://; # strip off the header
    if ($mount_var eq "") {$mount_var = $DEFAULT_LOCAL_MOUNT_POINT;}
    $which_mount = "local";
}
elsif ($mount_var =~ /^global/) {

    $mount_var=~ s/^global//; # strip off the header
    $mount_var=~ s/^://; # strip off the header
    $server_list = CT::CT::contact_t->new;  

    $which_mount = "global";

    # TODO: when the code is changed to support host names
    # in CT_SR_MOUNT, then this next line will be removed
    $mount_var = $DEFAULT_GLOBAL_MOUNT_POINT; 

# TODO: This will be used later. code is kept
# here so when it is figured out how to speak to
# daemons on other hosts, it can be used.
#   if ($mount_var eq "") { 
#       $mount_var = $DEFAULT_GLOBAL_MOUNT_POINT; 
        # $server_list values will be the default
        # NULL and 0.
#   }
#   else  {
        # Will be either hostname/port number or
        # IP/port number
        # Set up the contact_t values
        # The default values will be used for now.
#       ($name, $port) = split /:/, $mount_var;
#       $server_list->set_contact_point($name, $port);
#       $server_list->set_contact_type(CT_CONTACT_IP);
#       $server_list->set_array_count(1);
#   }   

}

$main::Verbose && 
    print STDERR "mount point: $mount_var, $which_mount\n";

return($mount_var, $which_mount, $server_list);
}   # end check_mount_env_var


#--------------------------------------------------------------------#
# init_session - Initializes Registry sessions, including opening    #
#   a session tree, mounting the working directory and changing the  #
#   current directory if required.                                   #
#                                                                    #
# Parameters:                                                        #
#   change_dir   in  1 if you wish init_session to change the        #
#                    current directory using SR sr_change_           #
#                    directory to CT_SR_HOME or system registry root.#
#                    0 do not change the current directory.          #
#                    Often called with results of isRelative(name)   #
#                                                                    #
# Returns:                                                           #
#   local_rc     0 - success                                         #
#                otherwise the bad return code returned from         #
#                CT::SR::open_tree, CT::SR::mount_directory,         #
#                SR::change_current_directory                        #
#   tree_handle  The result of CT::SR::sr_open_tree.                 #
#                                                                    #
# Global Variables:                                                  #
#  $main::Verbose  in  turns verbose mode on.                        #
#  $main::Trace    in  turns trace mode on. trace mode on.           #
#--------------------------------------------------------------------#
sub init_session 
{
($change_dir) = @_;    

# This routine will be used to test if the node is an IW
# Commented out next line until start using CT::CU::get_cluster_info
# to determine if System Registry is local or a server.
# Had to be commented out at this time since cu_get_cluster_info
# appears to have a memory leak and when only running in Single 
# System Image mode - don't need to determine if an IW or in a 
# cluster. 
# use CT::CU qw(get_cluster_info);

use Env qw(CT_SR_MOUNT CT_SR_HOME CT_SR_NUM_RETRIES CT_SR_TIMEOUT);

my $local_rc = 0;  
my $num_retries = 0;
my $timeout = 0;
my $tree_handle;
my $mount_sr_home;
my $mount_point = "";
my $which_mount = "";
# Commented out until cu_get_cluster_info is fixed.
# my $cluster_info = CT::CU::cluster_info_t->new;
my $cluster_name = "";

$main::Trace && print STDERR "Entered SR_cli_utils::init_session\n";

# display applicable environment variables
my $env_msg = "";
if ($main::Verbose) {
    if (defined $CT_SR_HOME) {
        $env_msg = $env_msg . "\n\tCT_SR_HOME ". $CT_SR_HOME;
    }
    if (defined $CT_SR_NUM_RETRIES) {
        $env_msg = $env_msg . 
			"\n\tCT_SR_NUM_RETRIES " . $CT_SR_NUM_RETRIES; 
    }
    if (defined $CT_SR_TIMEOUT) {
        $env_msg = $env_msg . "\n\tCT_SR_TIMEOUT". $CT_SR_TIMEOUT;
    }
    if (defined $CT_SR_MOUNT) {
        $env_msg = $env_msg . "\n\tCT_SR_MOUNT". $CT_SR_MOUNT;
    }
    printCIMsg("IMsgSRcliDisplayEnv", $env_msg); 
}

# Establish a session using either the system defaults for
# number of retries and timeout or the values that were sent using
# the environment variables $CT_SR_NUM_RETRIES or $CT_SR_TIMEOUT.

# TODO: Why does Registry drivers want -1 as num retries when
#   C API doc says that 0 should be set to get default.

$tree_handle = CT::SR::tree_handle_t->new();
$CT_SR_NUM_RETRIES ? $num_retries = $CT_SR_NUM_RETRIES 
                        : $num_retries = -1;
$CT_SR_TIMEOUT ? $timeout = $CT_SR_TIMEOUT : $timeout = 0;

# TODO the other Verbose messages here are really trace messages
# so they should not be catalogued 
# The messages that are $main::Trace or $main::Verbose will
# Become simply trace messages at the end of updating all the
# routines to match their approved man pages.
        
$main::Trace && 
    print STDERR "Calling CT::SR::open_tree num_retries=$num_retries timeout=$timeout\n";  
$local_rc = CT::SR::open_tree($tree_handle, $num_retries, $timeout);

if ($local_rc != 0) {
    $main::Trace && 
            print STDERR "CT::SR::open_tree return code: $local_rc\n";
    printCEMsg("EMsgSRcliSRCommandFailure", "sr_open_tree", $local_rc);
    $main::Trace && print STDERR "Leaving SR_cli_utils::init_session\n";
    return SR_CLI_REGISTRY_ERROR;
}


# Call the appropriate mount tree command based on
# the CT_SR_MOUNT environment variable, and the cluster name
if (defined($CT_SR_MOUNT)) {
    ($mount_point, $which_mount, $server_lst) = 
                check_mount_env_var($CT_SR_MOUNT);
}
else {

    # First, check if the node is an IW or not.
# TODO: This code is commented out until defect 63122 is dealt with.
# This call was causing seg faults in FVT.
#    $local_rc = CT::CU::get_cluster_info($cluster_info);
    
    if ($local_rc == 0) {
#       $cluster_name = 
#           CT::CU::cluster_info_t::get_cluster_name($cluster_info);
        $cluster_name = "IW";
        $main::Verbose && 
            print STDERR "Cluster Name: ", $cluster_name, "\n"; 
    }   

    # If there was an error running this command, go no further
    if ($local_rc != 0) {
        $main::Trace && 
            print STDERR "CT::CU::cluster_info_t::get_cluster_name return code: $local_rc\n";
        printCEMsg("EMsgSRcliSRCommandFailure", 
                    "sr_mount_directory", $local_rc);
        $local_rc = SR_CLI_REGISTRY_ERROR;
        $main::Trace && print STDERR "Leaving SR_cli_utils::init_session\n";
        return $local_rc;
    }

    # Continue processing based on results of get_cluster_name
    if ($cluster_name eq "IW") {
        # default to using a local persistent SDR
        # I assume the create flag will come in through the cli?
        ($mount_point, $which_mount, $server_list)  = 
                        check_mount_env_var("local");
    }
    else {
        $server_list = CT::CT::contact_t->new;  
        ($mount_point, $which_mount, $server_lst) = 
                        check_mount_env_var("global");
    }
}

# Call the appropriate mount command

if ($which_mount eq "local") {
    $fs_mount_point = $mount_point;
    $mount_point = $DEFAULT_GLOBAL_MOUNT_POINT;
    my $create = 1;  # Assume this to begin with. How can this
                     # be flagged? TODO

    $main::Trace && 
        print STDERR "Calling CT::SR::mount_local_tree($mount_point, $fs_mount_point, $create)\n";
    $local_rc = CT::SR::mount_local_tree($tree_handle, 
                        $mount_point, $fs_mount_point, $create);

    if ($local_rc != 0) {
        $main::Trace && 
            print STDERR "CT::SR::mount_local_tree return code: $local_rc\n";

# Maybe this return code comes back if have registry server? 
#        if ($local_rc == SR_INVALID_FS_DIRECTORY) {
#            printCEMsg("EMsgSRcliInvalidFSDir", $fs_mount_point);
#            $local_rc = SR_CLI_REGISTRY_ERROR;
#        }
        if ($local_rc == SR_INVALID_DIRECTORY) {
            printCEMsg("EMsgSRcliInvalidDirectory");
            $local_rc = SR_CLI_USER_ERROR;
        }
        else {
            printCEMsg("EMsgSRcliSRCommandFailure", 
                "sr_mount_directory", $local_rc);
            $local_rc = SR_CLI_REGISTRY_ERROR;
        }
        # TODO: when FFDC comes along, this should be returning
        # the registry error code to the calling Perl prog?
        #return SR_CLI_REGISTRY_ERROR;
        $main::Trace && print STDERR "Leaving SR_cli_utils::init_session\n";
        return $local_rc;
    }

}
elsif ($which_mount eq "global") {
    $main::Trace && 
        print STDERR "Calling CT::SR::mount_global_tree\n";
    $local_rc = CT::SR::mount_global_tree($tree_handle, 
                        $mount_point, $server_lst);

    if ($local_rc != 0) {
        $main::Trace && 
      print STDERR "CT::SR::mount_global_tree return code: $local_rc\n";
        if ($local_rc == SR_NO_SERVER) {
            printCEMsg("EMsgSRcliNoServer");
            $local_rc = SR_CLI_REGISTRY_ERROR;
        }
        elsif ($local_rc == SR_DIRECTORY_EXISTS) {
            printCEMsg("EMsgSRcliDirectoryExists");
            $local_rc = SR_CLI_USER_ERROR;
        }
        elsif ($local_rc == SR_INVALID_DIRECTORY) {
            printCEMsg("EMsgSRcliInvalidDirectory");
            $local_rc = SR_CLI_USER_ERROR;
        }
        elsif ($local_rc == SR_INVALID_SERVER) {
            printCEMsg("EMsgSRcliInvalidServer");
            $local_rc = SR_CLI_REGISTRY_ERROR;
        }
        else {
            printCEMsg("EMsgSRcliSRCommandFailure", 
                "sr_mount_directory", $local_rc);
            $local_rc = SR_CLI_REGISTRY_ERROR;
        }
        # TODO: when FFDC comes along, this should be returning
        # the registry error code to the calling Perl prog?
        #return SR_CLI_REGISTRY_ERROR;
        $main::Trace && print STDERR "Leaving SR_cli_utils::init_session\n";
        return $local_rc;

    }
}

        
# If any of the specified directories contain a relative path
# we should set the current directory if CT_SR_HOME is set.
if ($change_dir) {
#       if ($main::Verbose) { 
#           $CT_SR_HOME ? print "Current directory is $CT_SR_HOME\n" :
#                      print "Current directory is / (SR_ROOT)\n";
#       }
    $mount_sr_home = $mount_point . $CT_SR_HOME;
    $main::Trace && 
        print STDERR "Calling CT::SR::change_current_directory\n";
    $local_rc = CT::SR::change_current_directory($tree_handle, 
                        $mount_sr_home);

    if ($local_rc != 0) {
        $main::Trace && print STDERR "CT::SR::change_current_directory return code: $local_rc \n";
        if ($local_rc == SR_INVALID_DIRECTORY) {
            printCEMsg("EMsgSRcliInvalidDirectory");
            $local_rc = SR_CLI_USER_ERROR;
        }
        else {
            printCEMsg("EMsgSRcliCurrentDirError", $CT_SR_HOME);
            printCEMsg("EMsgSRcliSRCommandFailure", 
                "sr_change_current_directory", $local_rc);
            $local_rc = SR_CLI_REGISTRY_ERROR;
        }
        $main::Trace && print STDERR "Leaving SR_cli_utils::init_session\n";
        return $local_rc;
    }
}

$main::Trace && print STDERR "Leaving SR_cli_utils::init_session\n";

return( $local_rc, $tree_handle );
}; # end init_session


#--------------------------------------------------------------------#
# clean_session - Terminates session with the system registry,       #
#               closing all tables given,                            #
#               unmounting the working directory and closing the     #
#               tree.                                                #
#                                                                    #
# Parameters:                                                        #
#   tree_handle  in  Same tree handle that was returned from calling #
#                    init_session.                                   #
#   mount_point  in  Same as what was provided to init_session, the  #
#                    directory name where you mounted...             #
#                    Set to NULL if you only want to close the tree. #
#   @tables      in  Tables to be closed, if possible.               #
#                                                                    #
# Returns:                                                           #
#   local_rc     0 - success                                         #
#                otherwise the bad return code returned from         #
#                CT::SR::unmount_directory, CT::SR::close_tree       #
#                                                                    #
# Global Variables:                                                  #
#  $main::Verbose  in  turns verbose mode on.                        #
#  $main::Trace    in  turns trace mode on.                          #
#--------------------------------------------------------------------#
sub clean_session 
{
my ($tree, $mount_point, @tables) = @_;
my $local_rc = 0;
$main::Trace && print STDERR "Entered SR_cli_utils::clean_session\n";

foreach $table (@tables) {
    $main::Trace && 
        print STDERR "Calling CT::SR::close_table($table)\n";
    $local_rc = CT::SR::close_table($table);
    $main::Trace && 
        print STDERR "CT::SR::close_table return code $local_rc\n";

    if ($local_rc != 0)  {
        printCEMsg("EMsgSRcliErrorClosingTable", " "); 
        printCEMsg("EMsgSRcliCommandFailure", 
                            "sr_close_table", $local_rc);

        # Preserve error code - try to close tree anyway
        
        my $worstrc = term_session($tree, $mount_point);
        return SR_CLI_REGISTRY_ERROR
    }
}

# term_session handles it's own error messages.
$local_rc = term_session($tree, $mount_point);

$main::Trace && print STDERR "Leaving SR_cli_utils::clean_session\n";

return $local_rc;
}   # end clean_session


#--------------------------------------------------------------------#
# term_session - Terminates session with the system registry,        #
#               unmounting the working directory and closing the     #
#               tree.                                                #
#                                                                    #
# Parameters:                                                        #
#   tree_handle  in  Same tree handle that was returned from calling #
#                    init_session.                                   #
#   mount_point  in  Same as what was provided to init_session, the  #
#                    directory name where you mounted...             #
#                    Set to NULL if you only want to close the tree. #
#                                                                    #
# Returns:                                                           #
#   local_rc     0 - success                                         #
#                otherwise the bad return code returned from         #
#                CT::SR::unmount_directory, CT::SR::close_tree       #
#                                                                    #
# Global Variables:                                                  #
#  $main::Verbose  in  turns verbose mode on.                        #
#  $main::Trace    in  turns trace mode on.                          #
#--------------------------------------------------------------------#
sub term_session 
{
($tree_handle, $mount_point) = @_;

# TODO: when FFDC is put in place, the various error codes here will
# have to be trapped correctly. (feature 48397)

my $local_rc = 0;

$main::Trace && print STDERR "Entered SR_cli_utils::term_session\n";

if ($mount_point) {
    $main::Trace && 
        print STDERR "Calling CT::SR::unmount_directory $mount_point\n";

    $local_rc = CT::SR::unmount_directory($tree_handle, $mount_point);

    $main::Trace && print STDERR "CT::SR::unmount_directory return code: $local_rc \n";

    if ($local_rc != 0) {
        if ($local_rc == SR_INVALID_DIRECTORY) {
            printCEMsg("EMsgSRcliInvalidDirectory");
        }
        elsif ($local_rc == SR_NO_DIRECTORY) {
            printCEMsg("EMsgSRcliNoDirectory");
        }
        else {
            printCEMsg("EMsgSRcliSRCommandFailure", 
                "sr_unmount_directory", $local_rc); 
        }
    }
}

# Close the tree even if the unmount failed.                       
$main::Trace && print STDERR "Calling CT::SR::close_tree\n";  
$local_rc = CT::SR::close_tree($tree_handle);
$main::Trace && 
    print STDERR "CT::SR::close_tree return code: $local_rc\n";

if ($local_rc != 0) {
    printCEMsg("EMsgSRcliSRCommandFailure", "sr_close_tree", $local_rc);
    $local_rc = SR_CLI_REGISTRY_ERROR;
}

$main::Trace && print STDERR "Leaving SR_cli_utils::term_session\n";

return($local_rc);
}   # end term_session


#--------------------------------------------------------------------#
# isRelative - Checks to see if the name specified as input contains #
#   a relative path or an absolute path.  Absolute paths start with  #
#   a slash '/'.                                                     #
#                                                                    #
# Paramaters:                                                        #
#   File or directory name to be pattern matched                     #
#                                                                    #
# Return:                                                            #
#   1 - the input name contains a relative path.                     #
#   0 - the output name contains an absolute path.                   #
#                                                                    #
# Global Variables: None.                                            #
#--------------------------------------------------------------------#
sub isRelative 
{
return shift !~ /^\//;
}   # end isRelative


#--------------------------------------------------------------------#
# sub get_table_metadata:                                            #
#    Get table metadata associated with the table handled passed in. #
#    Check return code and report any error messages.                #
#                                                                    #
# Parameters:                                                        #
#   $table_handle - table to get metadata for.                       #
#                                                                    #
# Returns:                                                           #
#   $local_rc    0 - success                                         #
#                > 0 otherwise                                       #
#   $metadata    - table metadata.                                   #
#                                                                    #
# Global Variables:                                                  #
#  $main::Verbose  in  turns verbose mode on.                        #
#  $main::Trace    in  turns trace mode on.                          #
#--------------------------------------------------------------------#
sub get_table_metadata 
{
my ($table_handle) = @_;

my $local_rc = 0;

# Get the table metadata first
$metadata = CT::SR::table_metadata_t->new;

$main::Trace && print STDERR "Calling CT::SR::get_table_metadata\n";
$local_rc = CT::SR::get_table_metadata($table_handle, 1, $metadata);
$main::Trace && 
   print STDERR "CT::SR::get_table_metadata return code: $local_rc\n";

if ($local_rc != 0) {
    if ($local_rc == SR_NO_PERMISSION) {
        printCEMsg("EMsgSRcliNoPermissionTableMetadata", $table_name);
        $local_rc = SR_CLI_USER_ERROR;
    }
    else {
        printCEMsg("EMsgSRcliSRCommandFailure", 
                        "sr_get_table_metadata", $local_rc);
        $local_rc = SR_CLI_REGISTRY_ERROR;
    }
    return $local_rc;
}

return ($local_rc, $metadata);
}   # end get_table_metadata


#--------------------------------------------------------------------#
# sub free_table_metadata:                                           #
#    Free memory associated with table metadata passed in. Check     #
#    return code and report any error messages.                      #
#                                                                    #
# Parameters:                                                        #
#   $metadata - table metadata to be freed.                          #
#                                                                    #
# Returns:                                                           #
#   $local_rc    0 - success                                         #
#                > 0 otherwise                                       #
#                                                                    #
# Global Variables:                                                  #
#  $main::Verbose  in  turns verbose mode on.                        #
#  $main::Trace    in  turns trace mode on.                          #
#--------------------------------------------------------------------#
sub free_table_metadata 
{
my $metadata = shift;

# Free the table metadata and undef the memory for reclamation
# by the program. If $local_rc != 0, preserve the initial
# error code by using a disposable return code.
my $local_rc = 0;

$main::Trace && print STDERR "Calling CT::SR::free_table_metadata\n";
$local_rc  = CT::SR::free_table_metadata($metadata);
$main::Trace &&
    print STDERR "CT::SR::free_table_metadata return code: $local_rc\n";

if ($local_rc != 0) {
    printCEMsg("EMsgSRcliFreeMetadataError", $table_name);
    printCEMsg("EMsgSRcliSRCommandFailure", 
                "sr_free_table_metadata", $local_rc);
    $local_rc = SR_CLI_REGISTRY_ERROR;
}

return ($local_rc);
}   # end free_table_metadata


#--------------------------------------------------------------------#
# sub make_value_struct_t                                            #
#    Make a structure: an array containing references to two arrays. #
#    The first array ref is to an array of values (ct_value_t.)      #
#    The second array ref is to an array of data types (ints.)       #
#    If no input data is given, then the structure is set up with    #
#    just the data types array. (The structure is used this way for  #
#    input to CT::SR::get_fields_by_index, etc.)                     #
#                                                                    #
# Parameters:                                                        #
#   $column_defs - table metadata.                                   #
#   $columns_to_set - names of columns to use in the structure.      #
#                     (could be empty.)                              #
#   $print_system_cols - for checking if system columns are to be    #
#                        used in the case that $columns_to_set is    #
#                        empty.                                      #
#   $input_data - data to be converted and put in the first array    #
#                 in the structure.                                  #
#                                                                    #
# Returns:                                                           #
#   $local_rc    0 - success                                         #
#                > 0 otherwise                                       #
#   \@value_struct_t - array containing 2 array references.          #
#   \@cols - array reference containing list of columns used in the  #
#            @value_struct_t structure.                              #
#                                                                    #
# Global Variables:                                                  #
#  $main::Verbose  in  turns verbose mode on.                        #
#  $main::Trace    in  turns trace mode on.                          #
#--------------------------------------------------------------------#
sub make_value_struct_t 
{
my ($column_defs, $columns_to_set, $print_system_cols, $input_data) = @_;

# Pass in an empty array reference here if nothing is to come through
# Otherwise it is directly assigned over to the output array

my @value_struct_t = ();
my @data_types = ();
my @converted_values = ();
my @cols = ();
my $index = 0;

# Get the column definitions from the metadata, 
# for each column given, put the data type into
# the output data type array

my $local_rc = 0;
my $found = 0;

# Set up the arrays, depending on whether input values
# were given to be converted or not

if (defined($input_data)) {

OUTER:
    foreach $column (@$input_data) {
        $found = 0;
        foreach $entry (@$column_defs) {
            if ($column->[0] eq $entry->{name}) {
                # Get the data type and convert the
                # value over

                push @data_types, $entry->{type};

                ($local_rc, $converted_values[$index] ) = 
                    convert_input_value($entry->{type}, $column->[1], 
                        $entry->{sd_defn}->[1]);
                $cols[$index++] = $column->[0];
                $found = 1;
            }
        }
        if ($found == 0) {
            printCEMsg("EMsgSRcliInvalidColumnName", $column->[0]);  
            return SR_CLI_USER_ERROR;
        }
        
    }
}
else {

# Set up the columns to be working with list
if (scalar(@$columns_to_set) <= 0) {
    foreach $entry (@$column_defs) {
        if ($entry->{qualifier} == SR_SYSTEM && !$print_system_cols) {
             next; 
        }
        push @cols , $entry->{name};
    }
}
else {  @cols = @$columns_to_set; }

    foreach $name (@cols) {
        foreach $entry (@$column_defs) {
            if ($entry->{name} eq $name) {

                # Get the data type
                $data_types[$index++] =  $entry->{type};

            }
        }
    }
    @converted_values = ();

}

# Set the values for the output array
$value_struct_t[0] = [@converted_values];
$value_struct_t[1] = [@data_types];

return($local_rc, \@value_struct_t, \@cols);
} # end make_value_struct_t


#--------------------------------------------------------------------#
# sub get_fields_by_index:                                           #
#    Get fields from the table associated with the given             #
#    handle using an extension call, check the resulting return code #
#    report any errors, or return the fields.                        #
#                                                                    #
# Parameters:                                                        #
#   $table_handle - table to get metadata for.                       #
#   $row_index - index for row to retrieve from table.               #
#   $column_names - columns to retrieve.                             #
#   $value_struct_t - structure needed to have the extension return  #
#                     the requested data.                            #
#                                                                    #
# Returns:                                                           #
#   $local_rc    0 - success                                         #
#                > 0 otherwise                                       #
#   $output_results - input $value_struct_t, but also containing the #
#                     data requested.                                #
#                                                                    #
# Global Variables:                                                  #
#  $main::Verbose  in  turns verbose mode on.                        #
#  $main::Trace    in  turns trace mode on.                          #
#--------------------------------------------------------------------#
sub get_fields_by_index 
{
my ($table_handle, $row_index, $column_names, $value_struct_t) = @_;

# Set up local variables
my $output_results;
my $local_rc;

$main::Trace &&
    print STDERR "Calling CT::SR::get_fields_by_index for row $row_index\n";

($local_rc, $output_results) = 
    CT::SR::get_fields_by_index($table_handle, $row_index,
                        $column_names, $value_struct_t);
$main::Trace && 
    print STDERR "CT::SR::get_fields_by_index return code $local_rc\n";

# Check result of previous call
# Under normal Registry Library function, all these
# error codes should be trapped before this point. If they
# are not, then there may be something seriously wrong
# with the registry, or the table may have become corrupt.

if ($local_rc !=0) {
    if ($local_rc == SR_NO_PERMISSION) {
        printCEMsg("EMsgSRcliNoPermission", 
                        $table_name, "sr_get_fields_by_index");
        $local_rc = SR_CLI_USER_ERROR;  
    }
    elsif ($local_rc == SR_NO_TABLE) {
        printCEMsg("EMsgSRcliNoTable", $table_name);
        $local_rc = SR_CLI_USER_ERROR;  
    }
    elsif ($local_rc = SR_INVALID_ROW_INDEX) {
        printCEMsg("EMsgSRcliInvalidRowIndex",
                        $row_index);
        $local_rc = SR_CLI_ERROR;   
    }
    elsif ($local_rc = SR_NO_COLUMN) {
        printCEMsg("EMsgSRcliNoColumn");
        $local_rc = SR_CLI_USER_ERROR;  
    }
    else {
        printCEMsg("EMsgSRcliSRCommandFailure", 
                        "sr_get_fields_by_index", $local_rc);
        $local_rc = SR_CLI_REGISTRY_ERROR;  
    }
}

return($local_rc, $output_results);
} # end sub get_fields_by_index


#--------------------------------------------------------------------#
# sub open_table:                                                    #
#    Open a table in the given tree, according to permissions        #
#    requested. Check return code of the extension call,             #
#    report any errors, or return the fields.                        #
#                                                                    #
# Parameters:                                                        #
#   $tree_handle - session tree handle.                              #
#   $system_table_name - name of table to be opened.                 #
#   $table_name - relative name of table for error reporting.        #
#   $permissions - what mode to open the table in.                   #
#                                                                    #
# Returns:                                                           #
#   $local_rc    0 - success                                         #
#                > 0 otherwise                                       #
#   $output_results - input $value_struct_t, but also containing the #
#                     data requested.                                #
#                                                                    #
# Global Variables:                                                  #
#  $main::Verbose  in  turns verbose mode on.                        #
#  $main::Trace    in  turns trace mode on.                          #
#--------------------------------------------------------------------#
sub open_table 
{
my ($tree_handle, $system_table_name, $table_name, $permissions) = @_;

# TODO: add more return code messages so this is more diagnostic.

# Set up local variables
my $local_rc = 0;
my $table_handle = CT::SR::table_handle_t->new;

$main::Trace && 
    print STDERR "Entered SR_cli_utils::open_table($table_name)\n";

$main::Trace && print STDERR "Calling CT::SR::open_table\n";

$local_rc = CT::SR::open_table($tree_handle, $system_table_name, 
                        $permissions, $table_handle);

$main::Trace && 
    print STDERR "CT::SR::open_table return code: $local_rc\n";

if ($local_rc != 0)  {
    if ($local_rc == SR_NO_PERMISSION) {
        printCEMsg("EMsgSRcliNoPermissionOpenTable", $table_name);
        $local_rc = SR_CLI_USER_ERROR;
    }
    elsif ($local_rc == SR_NO_TABLE) {
        printCEMsg("EMsgSRcliTableNotFound", $table_name);
        $local_rc = SR_CLI_USER_ERROR;
    }
    elsif ($local_rc == SR_INVALID_MODE) {
        printCEMsg("EMsgSRcliInvalidOpenTableMode", $table_name);
        $local_rc = SR_CLI_ERROR;
    }
    elsif ($rc == SR_CONNECTION_LOST) {
        printCEMsg("EMsgSRcliConnectionLost");
        $rc = SR_CLI_REGISTRY_ERROR;
    }
    else {
        printCEMsg("EMsgSRcliErrorOpeningTable", 
                        $table_name, $local_rc);
        printCEMsg("EMsgSRcliSRCommandFailure", 
                        "sr_open_table", $local_rc);
        $local_rc = SR_CLI_REGISTRY_ERROR;
    }
}

$main::Trace && 
    print STDERR "Leaving SR_cli_utils::open_table($table_name)\n";

($local_rc > 0) ? return ($local_rc) :
                return ($local_rc, $table_handle);
} # end open_table


#--------------------------------------------------------------------#
# error_exit - performs required cleanup and exits. Uses             #
#       Does not return to the calling program. Exits within sub.    #
#                             processing of this command.            #
# Parameters:                                                        #
#   $badrc            in      Bad return code - bad enough to exit   #
#                             processing of this command.            #
# Exit:                                                              #
#   1 MC_CLI_RMC_ERROR        Underlying RMC error.                  #
#   2 MC_CLI_ERROR            Unexpected error in the command script.#
#   3 MC_CLI_BAD_FLAG         Input flag error.                      #
#   4 MC_CLI_BAD_OPERAND      Input operand error.                   #
#   5 MC_CLI_USER_ERROR       User error.                            #
#                                                                    #
# Global References:                                                 #
#   $main::Cleanup.    in     Hash indicating what needs to be       #
#                             cleaned up.                            #
#                             if {Session} defined - value is        #
#                             session handle that must be closed.    #
#                             if {Tables} defined - value is an      #
#                             array of table handles to be closed.   #
#--------------------------------------------------------------------#
sub error_exit
{
my ($badrc) = @_;

$main::Trace && print STDERR "Entered SR_cli_utils::error_exit\n";

# If a session with RMC was initialized terminate it
# we do not care about the term_session return code since we
# already had an error that is bad enough we are exiting
if ($main::Cleanup{Tables}) {
    my $rc = clean_session($main::Cleanup{Session},
                            $main::Mount_point, 
                            @{$main::Cleanup{Tables}});
}

elsif ($main::Cleanup{Session}) {
    my $rc = term_session($main::Cleanup{Session}, 
                            $main::Mount_point);
}

$main::Cleanup = ();

SWITCH: {
    ($badrc == SR_CLI_REGISTRY_ERROR)   && exit($badrc);
    ($badrc == SR_CLI_ERROR)       && exit($badrc);
    ($badrc == SR_CLI_BAD_FLAG)    && exit($badrc);
    ($badrc == SR_CLI_BAD_OPERAND) && exit($badrc);
    ($badrc == SR_CLI_USER_ERROR)  && exit($badrc);
    # At this point all return codes should have been converted to
    # a valid RMC CLI return code.  But if one wasn't write an
    # error message.
    printCEMsg("EMsgSRcliInvalidRC", $badrc);
    exit(SR_CLI_ERROR);
}   # end switch

return;
}   # end error_exit


#--------------------------------------------------------------------#
# printCIMsg : Calls $LSMSG to print out the common system           #
#   registry cli informational messages with the required paramaters.#
#   Messages printed to stdout.                                      #
#   This subroutine is like printIMsg except it is used to print     #
#   the common SR CLI messages which are in the srcli message set.   #
#                                                                    #
# Paramaters:                                                        #
#   msg       in  Message mnemonic / message number in a sense.      #
#   optargs   in  Extra arguments/parameters to send to LSMSG.       #
#                                                                    #
# Returns:  None.                                                    #
#                                                                    #
# Global Variables:                                                  #
#   $main::Trace    in  Prints extra info when trace is on.          #
#   $LSMSG          in  Path & Command to display messages.          #
#   $MSGCAT         in  SR CLI Message catalogue.                    #
#   $MSGSET         in  SR CLI common message set "srcli".           #
#--------------------------------------------------------------------#
sub printCIMsg
{
my ($msg, @optargs) = @_;
my ($optarg, $optargs);

$main::Trace &&
    print STDERR "$LSMSG $MSGSET $MSGCAT $msg @optargs\n";

# Keep the args to LSMSG separate by separating with single quotes
# but must replace internal single quotes with blanks or get an error.
# Must escape internal double quotes for the system call.
foreach $optarg (@optargs) {
    $optarg =~ s/'/ /g;
    $optarg =~ s/"/\\"/g;
}
$optargs = "'" . join("' '",@optargs) . "'";

(scalar @optargs > 0) ?
    system "$LSMSG $MSGSET $MSGCAT $msg $optargs" :
    system "$LSMSG $MSGSET $MSGCAT $msg";

return;
}   # end printCIMsg


#--------------------------------------------------------------------#
# printCEMsg : Calls $LSMSG to print out the common system           #
#   registry cli error messages with the required paramaters.        #
#   Messages printed to stderr.                                      #
#   This subroutine is like printEMsg except it is used to print     #
#   the common SR CLI messages which are in the srcli message set    #
#   and it prefixes the message with the appropriate program name.   #
#                                                                    #
# Paramaters:                                                        #
#   msg         Message mnemonic / message number in a sense.        #
#   optargs     Extra arguments/parameters to send to LSMSG.         #
#                                                                    #
# Returns:  None.                                                    #
#                                                                    #
# Global Variables:                                                  #
#   $main::Trace    in  Prints extra info when trace is on.          #
#   $main::PROGNAME in  Calling program/command for error message.   #
#   $LSMSG          in  Path and command to display messages.        #
#   $MSGCAT         in  SR CLI Message catalogue.                    #
#   $MSGSET         in  SR CLI common message set "srcli".           #
#--------------------------------------------------------------------#
sub printCEMsg
{
my ($msg, @optargs) = @_;
my ($optarg, $optargs);

$main::Trace &&
    print STDERR "$LSMSG $MSGSET $MSGCAT $msg $main::PROGNAME @optargs\n";

# Keep the args to LSMSG separate by separating with single quotes
# but must replace internal single quotes with blanks or get an error.
# Must escape internal double quotes for the system call.
foreach $optarg (@optargs) {
    $optarg =~ s/'/ /g;
    $optarg =~ s/"/\\"/g;
}
$optargs = "'" . join("' '",@optargs) . "'";

(scalar @optargs > 0) ?
    system "$LSMSG $MSGSET $MSGCAT $msg $main::PROGNAME $optargs 1>&2" :
    system "$LSMSG $MSGSET $MSGCAT $msg $main::PROGNAME 1>&2";

return;
}   # end printCEMsg


#--------------------------------------------------------------------#
# End Exported Subroutines (with @EXPORT_OK, -> on demand).          #
#--------------------------------------------------------------------#

#--------------------------------------------------------------------#
# End of File                                                        #
#--------------------------------------------------------------------#
